/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.preview.internal;

import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.EclipseUtil;
import com.aptana.core.util.IConfigurationElementProcessor;
import com.aptana.preview.IPreviewHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;

public final class PreviewHandlers {
    private static final String EXTENSION_POINT_ID = "previewHandlers";
    private static final String TAG_HANDLER = "handler";
    private static final String ATT_CLASS = "class";
    private static final String ATT_CONTENTTYPE = "contentType";
    private static PreviewHandlers instance = null;
    private Map<IContentType, IConfigurationElement> configurations = new HashMap<IContentType, IConfigurationElement>();

    private PreviewHandlers() {
        this.readExtensionRegistry();
    }

    public static PreviewHandlers getInstance() {
        if (instance == null) {
            instance = new PreviewHandlers();
        }
        return instance;
    }

    private void readExtensionRegistry() {
        EclipseUtil.processConfigurationElements((String)"com.aptana.preview", (String)EXTENSION_POINT_ID, (IConfigurationElementProcessor)new IConfigurationElementProcessor(){

            public void processElement(IConfigurationElement element) {
                PreviewHandlers.this.readElement(element);
            }

            public Set<String> getSupportElementNames() {
                return CollectionsUtil.newSet((Object[])new String[]{PreviewHandlers.TAG_HANDLER});
            }
        });
    }

    private void readElement(IConfigurationElement element) {
        if (TAG_HANDLER.equals(element.getName())) {
            String clazz = element.getAttribute(ATT_CLASS);
            if (clazz == null || clazz.length() == 0) {
                return;
            }
            String contentTypeId = element.getAttribute(ATT_CONTENTTYPE);
            if (contentTypeId == null || contentTypeId.length() == 0) {
                return;
            }
            IContentType contentType = Platform.getContentTypeManager().getContentType(contentTypeId);
            if (contentType == null) {
                return;
            }
            this.configurations.put(contentType, element);
        }
    }

    public IPreviewHandler getHandler(IContentType contentType) throws CoreException {
        IConfigurationElement element = null;
        while (contentType != null && element == null) {
            element = this.configurations.get(contentType);
            contentType = contentType.getBaseType();
        }
        if (element != null) {
            return (IPreviewHandler)element.createExecutableExtension(ATT_CLASS);
        }
        return null;
    }
}

